/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.utils;

import com.google.common.collect.ObjectArrays;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.api.SkillsAPI;

public class CommandUtils {
    public static Category getCategory(ResourceLocation categoryId) throws CommandSyntaxException {
        return SkillsAPI.getCategory(categoryId).orElseThrow(() -> new SimpleCommandExceptionType((Message)SkillsMod.createTranslatable("command", "no_such_category", categoryId)).create());
    }

    public static Skill getSkill(Category category, String skillId) throws CommandSyntaxException {
        return category.getSkill(skillId).orElseThrow(() -> new SimpleCommandExceptionType((Message)SkillsMod.createTranslatable("command", "no_such_skill", skillId)).create());
    }

    public static int sendSuccess(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players, String command, Object ... args) {
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)SkillsMod.createTranslatable("command", command + ".success.single", ObjectArrays.concat((Object[])args, (Object)players.iterator().next().m_5446_())), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)SkillsMod.createTranslatable("command", command + ".success.multiple", ObjectArrays.concat((Object[])args, (Object)players.size())), true);
        }
        return players.size();
    }
}

